<?php
class ControllerExtensionModuleFeatured extends Controller {
	public function index($setting) {
		$this->load->language('extension/module/featured');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');


		$data['badge_recently_added'] = $this->config->get('mart_badge_recently_added');
		$data['badge_recently_added_label'] = $this->config->get('mart_badge_recently_added_label');
		$data['badge_sale'] = $this->config->get('mart_badge_sale');
		$data['badge_sale_label'] = $this->config->get('mart_badge_sale_label');
		$data['badge_out_of_stock'] = $this->config->get('mart_badge_out_of_stock');
		$data['badge_out_of_stock_label'] = $this->config->get('mart_badge_out_of_stock_label');
		$data['product_color_options'] = $this->config->get('mart_product_color_options');

		if ($this->config->get('mart_badge_recently_added_limit')) {
			$recently_added_limit = (int)$this->config->get('mart_badge_recently_added_limit');
		} else {
			$recently_added_limit = 10;
		}
      
		$data['products'] = array();

		if (!$setting['limit']) {
			$setting['limit'] = 4;
		}

		if (!empty($setting['product'])) {
			$products = array_slice($setting['product'], 0, (int)$setting['limit']);

			$filter_data_latest = array(
				'sort' => 'p.date_added',
				'order' => 'DESC',
				'start' => 0,
				'limit' => $recently_added_limit
			);

			$results_latest = $this->model_catalog_product->getProducts($filter_data_latest);
      

			foreach ($products as $product_id) {
				$product_info = $this->model_catalog_product->getProduct($product_id);

				if ($product_info) {

					if (array_key_exists($product_info['product_id'], $results_latest)) {
						$recently_added = true;
					} else {
						$recently_added = false;
					}

					if ($product_info['quantity'] <= 0) {
						$out_of_stock = true;
					} else {
						$out_of_stock = false;
					}
      
					if ($product_info['image']) {
						$image = $this->model_tool_image->resize($product_info['image'], $setting['width'], $setting['height']);
					} else {
						$image = $this->model_tool_image->resize('placeholder.png', $setting['width'], $setting['height']);
					}

					if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
						$price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					} else {
						$price = false;
					}

					if ((float)$product_info['special']) {
						$special = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					} else {
						$special = false;
					}

					if ($this->config->get('config_tax')) {
						$tax = $this->currency->format((float)$product_info['special'] ? $product_info['special'] : $product_info['price'], $this->session->data['currency']);
					} else {
						$tax = false;
					}

					if ($this->config->get('config_review_status')) {
						$rating = $product_info['rating'];
					} else {
						$rating = false;
					}


					$product_color_options = $this->model_catalog_product->getProductColorOptions($product_info['product_id']);
      
					$data['products'][] = array(
						'product_id'  => $product_info['product_id'],
						'thumb'       => $image,
						'name'        => $product_info['name'],
						'description' => utf8_substr(strip_tags(html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
						'price'       => $price,
						'special'     => $special,
						'tax'         => $tax,
						'rating'      => $rating,

						'colors'         => $product_color_options,
						'recently_added' => $recently_added,
						'out_of_stock'   => $out_of_stock,
      
						'href'        => $this->url->link('product/product', 'product_id=' . $product_info['product_id'])
					);
				}
			}
		}

		if ($data['products']) {
			return $this->load->view('extension/module/featured', $data);
		}
	}
}