<?php
class ControllerCommonHeader extends Controller {
	public function index() {
		// Analytics
		$this->load->model('setting/extension');

		$data['analytics'] = array();

		$analytics = $this->model_setting_extension->getExtensions('analytics');

		foreach ($analytics as $analytic) {
			if ($this->config->get('analytics_' . $analytic['code'] . '_status')) {
				$data['analytics'][] = $this->load->controller('extension/analytics/' . $analytic['code'], $this->config->get('analytics_' . $analytic['code'] . '_status'));
			}
		}

		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}

		if (is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->document->addLink($server . 'image/' . $this->config->get('config_icon'), 'icon');
		}

		$data['title'] = $this->document->getTitle();

		$data['base'] = $server;
		$data['description'] = $this->document->getDescription();
		$data['keywords'] = $this->document->getKeywords();
		$data['links'] = $this->document->getLinks();
		$data['styles'] = $this->document->getStyles();
		$data['scripts'] = $this->document->getScripts('header');
		$data['lang'] = $this->language->get('code');
		$data['direction'] = $this->language->get('direction');

		$data['name'] = $this->config->get('config_name');

		if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
			$data['logo'] = $server . 'image/' . $this->config->get('config_logo');
		} else {
			$data['logo'] = '';
		}

		$this->load->language('common/header');

		// Wishlist
		if ($this->customer->isLogged()) {
			$this->load->model('account/wishlist');

			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), $this->model_account_wishlist->getTotalWishlist());
		} else {
			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
		}

		$data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('account/account', '', true), $this->customer->getFirstName(), $this->url->link('account/logout', '', true));
		
		$data['home'] = $this->url->link('common/home');
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['logged'] = $this->customer->isLogged();
		$data['account'] = $this->url->link('account/account', '', true);
		$data['register'] = $this->url->link('account/register', '', true);
		$data['login'] = $this->url->link('account/login', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['transaction'] = $this->url->link('account/transaction', '', true);
		$data['download'] = $this->url->link('account/download', '', true);
		$data['logout'] = $this->url->link('account/logout', '', true);
		$data['shopping_cart'] = $this->url->link('checkout/cart');
		$data['checkout'] = $this->url->link('checkout/checkout', '', true);
		$data['contact'] = $this->url->link('information/contact');
		$data['telephone'] = $this->config->get('config_telephone');

		$data['edition'] = $this->config->get('mart_edition');
		$data['container'] = $this->config->get('mart_container');
		$data['scheme'] = $this->config->get('mart_scheme');
		$data['typeface_url'] = $this->config->get('mart_typeface');
		$data['rtl'] = $this->config->get('mart_rtl');
		$data['navbar_fixed'] = $this->config->get('mart_navbar_fixed');
		$data['animated_page_load'] = $this->config->get('mart_animated_page_load');
		$data['image_protection'] = $this->config->get('mart_image_protection');
		$data['copy_protection'] = $this->config->get('mart_copy_protection');
		$data['custom'] = $this->config->get('mart_colors');
		$data['base_color'] = $this->config->get('mart_base_color');
		$data['btn_primary_bg'] = $this->config->get('mart_btn_primary_bg');
		$data['btn_primary_bg_hover'] = $this->config->get('mart_btn_primary_bg_hover');
		$data['btn_primary_border'] = $this->config->get('mart_btn_primary_border');
		$data['btn_primary_border_hover'] = $this->config->get('mart_btn_primary_border_hover');
		$data['quantity_counter_bg'] = $this->config->get('mart_quantity_counter_bg');
		$data['badge_recently_added_color'] = $this->config->get('mart_badge_recently_added_color');
		$data['badge_recently_added_bg'] = $this->config->get('mart_badge_recently_added_bg');
		$data['badge_sale_color'] = $this->config->get('mart_badge_sale_color');
		$data['badge_sale_bg'] = $this->config->get('mart_badge_sale_bg');
		$data['badge_out_of_stock_color'] = $this->config->get('mart_badge_out_of_stock_color');
		$data['badge_out_of_stock_bg'] = $this->config->get('mart_badge_out_of_stock_bg');

		if (isset($data['scheme']) && $data['scheme'] != 'default') {
			$scheme = explode(',', $data['scheme']);
			$data['scheme_color_primary'] = $scheme[0];
			$data['scheme_color_secondary'] = $scheme[1];
		}

		if (isset($data['typeface_url'])) {
			$matches = array();
			preg_match('/=(.*?)\:/s', $data['typeface_url'], $matches);
			$data['typeface_name'] = strtolower($matches[1]);
		}
      
		
		$data['language'] = $this->load->controller('common/language');
		$data['currency'] = $this->load->controller('common/currency');
		$data['search'] = $this->load->controller('common/search');
		$data['cart'] = $this->load->controller('common/cart');
		$data['menu'] = $this->load->controller('common/menu');

		return $this->load->view('common/header', $data);
	}
}
